/**
 * A javascript module to handle summary modal.
 *
 * @module     core_calendar/summary_modal
 * @package    core_calendar
 * @copyright  2017 Simey Lameze <simey@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_calendar/summary_modal",["jquery","core/str","core/notification","core/custom_interaction_events","core/modal","core/modal_registry","core/modal_factory","core/modal_events","core_calendar/repository","core_calendar/events","core_calendar/crud"],(function($,Str,Notification,CustomEvents,Modal,ModalRegistry,ModalFactory,ModalEvents,CalendarRepository,CalendarEvents,CalendarCrud){var registered=!1,SELECTORS_ROOT="[data-region='summary-modal-container']",SELECTORS_EDIT_BUTTON='[data-action="edit"]',SELECTORS_DELETE_BUTTON='[data-action="delete"]',ModalEventSummary=function(root){Modal.call(this,root)};return ModalEventSummary.TYPE="core_calendar-event_summary",(ModalEventSummary.prototype=Object.create(Modal.prototype)).constructor=ModalEventSummary,ModalEventSummary.prototype.getEditButton=function(){return void 0===this.editButton&&(this.editButton=this.getFooter().find(SELECTORS_EDIT_BUTTON)),this.editButton},ModalEventSummary.prototype.getDeleteButton=function(){return void 0===this.deleteButton&&(this.deleteButton=this.getFooter().find(SELECTORS_DELETE_BUTTON)),this.deleteButton},ModalEventSummary.prototype.getEventId=function(){return this.getBody().find(SELECTORS_ROOT).attr("data-event-id")},ModalEventSummary.prototype.getEventTitle=function(){return this.getBody().find(SELECTORS_ROOT).attr("data-event-title")},ModalEventSummary.prototype.getEventCount=function(){return this.getBody().find(SELECTORS_ROOT).attr("data-event-count")},ModalEventSummary.prototype.getEditUrl=function(){return this.getBody().find(SELECTORS_ROOT).attr("data-edit-url")},ModalEventSummary.prototype.isActionEvent=function(){return"true"==this.getBody().find(SELECTORS_ROOT).attr("data-action-event")},ModalEventSummary.prototype.registerEventListeners=function(){Modal.prototype.registerEventListeners.call(this),M.util.js_pending("core_calendar/summary_modal:registerEventListeners:bodyRendered"),this.getRoot().on(ModalEvents.bodyRendered,function(){this.getModal().data({eventTitle:this.getEventTitle(),eventId:this.getEventId(),eventCount:this.getEventCount()}).attr("data-type","event"),CalendarCrud.registerRemove(this.getModal()),M.util.js_complete("core_calendar/summary_modal:registerEventListeners:bodyRendered")}.bind(this)),$("body").on(CalendarEvents.deleted,function(){this.hide()}.bind(this)),CustomEvents.define(this.getEditButton(),[CustomEvents.events.activate]),this.getEditButton().on(CustomEvents.events.activate,function(e,data){this.isActionEvent()?$("body").trigger(CalendarEvents.editActionEvent,[this.getEditUrl()]):$("body").trigger(CalendarEvents.editEvent,[this.getEventId()]),this.hide(),e.preventDefault(),e.stopPropagation(),data.originalEvent.preventDefault(),data.originalEvent.stopPropagation()}.bind(this))},registered||(ModalRegistry.register(ModalEventSummary.TYPE,ModalEventSummary,"core_calendar/event_summary_modal"),registered=!0),ModalEventSummary}));

//# sourceMappingURL=summary_modal.min.js.map