/**
 * A timer that will execute a callback with decreasing frequency. Useful for
 * doing polling on the server without overwhelming it with requests.
 *
 * @module     core/backoff_timer
 * @class      backoff_timer
 * @package    core
 * @copyright  2016 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/backoff_timer",(function(){var BackoffTimer=function(callback,backoffFunction){this.callback=callback,this.backOffFunction=backoffFunction};return BackoffTimer.prototype.callback=null,BackoffTimer.prototype.backOffFunction=null,BackoffTimer.prototype.time=null,BackoffTimer.prototype.timeout=null,BackoffTimer.prototype.generateNextTime=function(){var newTime=this.backOffFunction(this.time);return this.time=newTime,newTime},BackoffTimer.prototype.reset=function(){return this.time=null,this.stop(),this},BackoffTimer.prototype.stop=function(){return this.timeout&&(window.clearTimeout(this.timeout),this.timeout=null),this},BackoffTimer.prototype.start=function(){if(!this.timeout){var time=this.generateNextTime();this.timeout=window.setTimeout(function(){this.callback(),this.stop(),this.start()}.bind(this),time)}return this},BackoffTimer.prototype.restart=function(){return this.reset().start()},BackoffTimer.getIncrementalCallback=function(minamount,incrementamount,maxamount,timeoutamount){return function(time){return time?time+incrementamount>maxamount?timeoutamount:time+incrementamount:minamount}},BackoffTimer}));

//# sourceMappingURL=backoff_timer.min.js.map