/**
 * Module for text truncation.
 *
 * Implementation provided by Pathable (thanks!).
 * See: https://github.com/pathable/truncate
 *
 * @module     core/truncate
 * @package    core
 * @class      truncate
 * @copyright  2017 Pathable
 *             2017 Mathias Bynens
 *             2017 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core/truncate",["jquery"],(function($){var chop=/(\s*\S+|\s)$/,start=/^(\S*)/,space=/\s/,charLengthAt=function(text,position){var string=String(text),size=string.length,index=position?Number(position):0;if(index!=index&&(index=0),index<=-1||index>=size)return"";index|=0;var cuSecond,cuFirst=string.charCodeAt(index),nextIndex=index+1,len=1;return cuFirst>=55296&&cuFirst<=56319&&size>nextIndex&&(cuSecond=string.charCodeAt(nextIndex))>=56320&&cuSecond<=57343&&(len=2),len},lengthMultiByte=function(text){for(var count=0,i=0;i<text.length;i+=charLengthAt(text,i))count++;return count},getSliceLength=function(text,amount){if(!text.length)return 0;var length=0,count=0;do{length+=charLengthAt(text,length),count++}while(length<text.length&&count<amount);return length};return $.truncate=function(html,options){return $("<div></div>").append(html).truncate(options).html()},$.fn.truncate=function(options){isNaN(parseFloat(options))||(options={length:options});var o=$.extend({},$.truncate.defaults,options);return this.each((function(){var self=$(this);o.noBreaks&&self.find("br").replaceWith(" ");var ellipsisLength=o.ellipsis.length,text=self.text(),textLength=lengthMultiByte(text),excess=textLength-o.length+ellipsisLength;if(!(textLength<o.length)){if(o.stripTags&&self.text(text),o.words&&excess>0){var sliced=text.slice(0,getSliceLength(text,o.length-ellipsisLength)+1),replaced=sliced.replace(chop,""),truncated=lengthMultiByte(replaced),oneWord=!sliced.match(space);excess=o.keepFirstWord&&0===truncated?textLength-lengthMultiByte(start.exec(text)[0])-ellipsisLength:oneWord&&0===truncated?textLength-o.length+ellipsisLength:textLength-truncated-1}excess>textLength&&(excess=textLength-o.length),excess<0||!excess&&!o.truncated||$.each(self.contents().get().reverse(),(function(i,el){var $el=$(el),text=$el.text(),length=lengthMultiByte(text);if(length<=excess)return o.truncated=!0,excess-=length,void $el.remove();if(3===el.nodeType){var splitAmount=length-excess;return splitAmount=splitAmount>=0?getSliceLength(text,splitAmount):0,$(el.splitText(splitAmount)).replaceWith(o.ellipsis),!1}return $el.truncate($.extend(o,{length:length-excess+ellipsisLength})),!1}))}}))},$.truncate.defaults={stripTags:!1,words:!1,keepFirstWord:!1,noBreaks:!1,length:1/0,ellipsis:"…"},{truncate:$.truncate}}));

//# sourceMappingURL=truncate.min.js.map