/**
 * This module updates the UI for the conversation page in the message
 * drawer.
 *
 * The module will take a patch from the message_drawer_view_conversation_patcher
 * module and update the UI to reflect the changes.
 *
 * This is the only module that ever modifies the UI of the conversation page.
 *
 * @module     core_message/message_drawer_view_conversation_renderer
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_conversation_renderer",["jquery","core/notification","core/str","core/templates","core/user_date","core_message/message_drawer_view_conversation_constants"],(function($,Notification,Str,Templates,UserDate,Constants){var SELECTORS=Constants.SELECTORS,TEMPLATES=Constants.TEMPLATES,CONVERSATION_TYPES=Constants.CONVERSATION_TYPES,getMessagesContainer=function(body){return body.find(SELECTORS.CONTENT_MESSAGES_CONTAINER)},getSelfConversationMessageContainer=function(body){return body.find(SELECTORS.SELF_CONVERSATION_MESSAGE_CONTAINER)},getContactRequestSentContainer=function(body){return body.find(SELECTORS.CONTACT_REQUEST_SENT_MESSAGE_CONTAINER)},getFooterContentContainer=function(footer){return footer.find(SELECTORS.CONTENT_MESSAGES_FOOTER_CONTAINER)},getFooterEditModeContainer=function(footer){return footer.find(SELECTORS.CONTENT_MESSAGES_FOOTER_EDIT_MODE_CONTAINER)},getFooterPlaceholderContainer=function(footer){return footer.find(SELECTORS.PLACEHOLDER_CONTAINER)},showFooterPlaceholder=function(footer){getFooterPlaceholderContainer(footer).removeClass("hidden")},getFooterRequireContactContainer=function(footer){return footer.find(SELECTORS.CONTENT_MESSAGES_FOOTER_REQUIRE_CONTACT_CONTAINER)},getFooterRequireUnblockContainer=function(footer){return footer.find(SELECTORS.CONTENT_MESSAGES_FOOTER_REQUIRE_UNBLOCK_CONTAINER)},getFooterUnableToMessageContainer=function(footer){return footer.find(SELECTORS.CONTENT_MESSAGES_FOOTER_UNABLE_TO_MESSAGE_CONTAINER)},hideAllFooterElements=function(footer){!function(footer){getFooterContentContainer(footer).addClass("hidden")}(footer),function(footer){getFooterEditModeContainer(footer).addClass("hidden")}(footer),function(footer){getFooterPlaceholderContainer(footer).addClass("hidden")}(footer),function(footer){getFooterRequireContactContainer(footer).addClass("hidden")}(footer),function(footer){getFooterRequireUnblockContainer(footer).addClass("hidden")}(footer),function(footer){getFooterUnableToMessageContainer(footer).addClass("hidden")}(footer)},getContentPlaceholderContainer=function(body){return body.find(SELECTORS.CONTENT_PLACEHOLDER_CONTAINER)},getHeaderContent=function(header){return header.find(SELECTORS.HEADER)},showHeaderContent=function(header){getHeaderContent(header).removeClass("hidden")},hideHeaderContent=function(header){getHeaderContent(header).addClass("hidden")},getHeaderEditMode=function(header){return header.find(SELECTORS.HEADER_EDIT_MODE)},hideHeaderEditMode=function(header){getHeaderEditMode(header).addClass("hidden")},getHeaderPlaceholderContainer=function(header){return header.find(SELECTORS.HEADER_PLACEHOLDER_CONTAINER)},showHeaderPlaceholder=function(header){getHeaderPlaceholderContainer(header).removeClass("hidden")},hideHeaderPlaceholder=function(header){getHeaderPlaceholderContainer(header).addClass("hidden")},getMessageElement=function(body,messageId){return getMessagesContainer(body).find('[data-message-id="'+messageId+'"]')},getDayElement=function(body,dayTimeCreated){return getMessagesContainer(body).find('[data-day-id="'+dayTimeCreated+'"]')},getMoreMessagesLoadingIconContainer=function(body){return body.find(SELECTORS.MORE_MESSAGES_LOADING_ICON_CONTAINER)},getConfirmDialogueContainer=function(root){return root.find(SELECTORS.CONFIRM_DIALOGUE_CONTAINER)},showConfirmDialogueContainer=function(root){var container=getConfirmDialogueContainer(root),siblings=container.siblings(":not(.hidden)");siblings.attr("aria-hidden",!0),siblings.attr("tabindex",-1),siblings.attr("data-confirm-dialogue-hidden",!0),container.removeClass("hidden")},hideConfirmDialogueContainer=function(root){var container=getConfirmDialogueContainer(root),siblings=container.siblings('[data-confirm-dialogue-hidden="true"]');siblings.removeAttr("aria-hidden"),siblings.removeAttr("tabindex"),siblings.removeAttr("data-confirm-dialogue-hidden"),container.addClass("hidden")},formatMessagesForTemplate=function(messages,datesCache){return messages.map((function(message){return{id:message.id,isread:message.isRead,fromloggedinuser:message.fromLoggedInUser,userfrom:message.userFrom,text:message.text,formattedtime:message.timeCreated?datesCache[message.timeCreated]:null}}))},renderConversation=function(header,body,footer,data){var renderingPromises=[],hasAddDays=data.days.add.length>0,hasAddMessages=data.messages.add.length>0,hasUpdateMessages=data.messages.update.length>0,timestampsToFormat=[],datesCachePromise=$.Deferred().resolve({}).promise();return hasAddDays&&(timestampsToFormat=timestampsToFormat.concat(data.days.add.reduce((function(carry,day){return carry.concat(day.value.messages.reduce((function(timestamps,message){return message.timeCreated&&timestamps.push(message.timeCreated),timestamps}),[]))}),[]))),hasAddMessages&&(timestampsToFormat=timestampsToFormat.concat(data.messages.add.reduce((function(timestamps,message){return message.value.timeCreated&&timestamps.push(message.value.timeCreated),timestamps}),[]))),hasUpdateMessages&&(timestampsToFormat=timestampsToFormat.concat(data.messages.update.reduce((function(timestamps,message){return message.before.timeCreated!=message.after.timeCreated&&timestamps.push(message.after.timeCreated),timestamps}),[]))),timestampsToFormat.length&&(datesCachePromise=Str.get_string("strftimetime24","core_langconfig").then((function(format){var requests=timestampsToFormat.map((function(timestamp){return{timestamp:timestamp,format:format}}));return UserDate.get(requests)})).then((function(formattedTimes){return timestampsToFormat.reduce((function(carry,timestamp,index){return carry[timestamp]=formattedTimes[index],carry}),{})}))),hasAddDays&&renderingPromises.push(datesCachePromise.then((function(datesCache){return function(header,body,footer,days,datesCache){var messagesContainer=getMessagesContainer(body),daysRenderPromises=days.map((function(data){return Templates.render(TEMPLATES.DAY,{timestamp:data.value.timestamp,messages:formatMessagesForTemplate(data.value.messages,datesCache)})}));return $.when.apply($,daysRenderPromises).then((function(){days.forEach((function(data,index){daysRenderPromises[index].then((function(html){if(data.before){var element=getDayElement(body,data.before.timestamp);return $(html).insertBefore(element)}return messagesContainer.append(html)})).catch((function(){}))}))}))}(0,body,0,data.days.add,datesCache)}))),hasAddMessages&&renderingPromises.push(datesCachePromise.then((function(datesCache){return function(header,body,footer,messages,datesCache){var messagesData=messages.map((function(data){return data.value})),formattedMessages=formatMessagesForTemplate(messagesData,datesCache);return Templates.render(TEMPLATES.MESSAGES,{messages:formattedMessages}).then((function(html){var messageList=$(html);messages.forEach((function(data){var messageHtml=messageList.find('[data-message-id="'+data.value.id+'"]');if(data.before){var element=getMessageElement(body,data.before.id);return messageHtml.insertBefore(element)}return getDayElement(body,data.day.timestamp).find(SELECTORS.DAY_MESSAGES_CONTAINER).append(messageHtml)}))}))}(0,body,0,data.messages.add,datesCache)}))),hasUpdateMessages&&renderingPromises.push(datesCachePromise.then((function(datesCache){return function(header,body,footer,messages,datesCache){messages.forEach((function(message){var before=message.before,after=message.after,element=getMessageElement(body,before.id);if(before.id!=after.id&&element.attr("data-message-id",after.id),before.timeCreated!=after.timeCreated){var formattedTime=datesCache[after.timeCreated];element.find(SELECTORS.LOADING_ICON_CONTAINER).addClass("hidden"),element.find(SELECTORS.TIME_CREATED).text(formattedTime).removeClass("hidden")}if(before.sendState!=after.sendState){var loading=element.find(SELECTORS.LOADING_ICON_CONTAINER),time=element.find(SELECTORS.TIME_CREATED),retry=element.find(SELECTORS.RETRY_SEND);switch(loading.addClass("hidden"),loading.attr("aria-hidden","true"),time.addClass("hidden"),time.attr("aria-hidden","true"),retry.addClass("hidden"),retry.attr("aria-hidden","true"),element.removeClass("border border-danger"),after.sendState){case"pending":loading.removeClass("hidden"),loading.attr("aria-hidden","false");break;case"error":retry.removeClass("hidden"),retry.attr("aria-hidden","false"),element.addClass("border border-danger");break;case"sent":time.removeClass("hidden"),time.attr("aria-hidden","false")}}if(before.text!=after.text&&element.find(SELECTORS.TEXT_CONTAINER).html(after.text),before.errorMessage!=after.errorMessage){var messageContainer=element.find(SELECTORS.ERROR_MESSAGE_CONTAINER);message=messageContainer.find(SELECTORS.ERROR_MESSAGE),after.errorMessage?(messageContainer.removeClass("hidden"),messageContainer.attr("aria-hidden","false"),message.text(after.errorMessage)):(messageContainer.addClass("hidden"),messageContainer.attr("aria-hidden","true"),message.text(""))}}))}(0,body,0,data.messages.update,datesCache)}))),data.days.remove.length>0&&function(body,days){days.forEach((function(data){getDayElement(body,data.timestamp).remove()}))}(body,data.days.remove),data.messages.remove.length>0&&function(body,messages){messages.forEach((function(data){getMessageElement(body,data.id).remove()}))}(body,data.messages.remove),$.when.apply($,renderingPromises)},renderHeader=function(header,body,footer,data){var headerContainer=getHeaderContent(header),template=TEMPLATES.HEADER_PUBLIC;return data.context.showrouteback="false"===header.attr("data-from-panel"),data.type==CONVERSATION_TYPES.PRIVATE?template=data.showControls?TEMPLATES.HEADER_PRIVATE:TEMPLATES.HEADER_PRIVATE_NO_CONTROLS:data.type==CONVERSATION_TYPES.SELF&&(template=TEMPLATES.HEADER_SELF),Templates.render(template,data.context).then((function(html,js){Templates.replaceNodeContents(headerContainer,html,js)}))},renderFooter=function(header,body,footer,data){switch(hideAllFooterElements(footer),data.type){case"placeholder":return showFooterPlaceholder(footer);case"add-contact":return Str.get_strings([{key:"requirecontacttomessage",component:"core_message",param:data.user.fullname},{key:"isnotinyourcontacts",component:"core_message",param:data.user.fullname}]).then((function(strings){var title=strings[1],text=strings[0],footerContainer=getFooterRequireContactContainer(footer);return footerContainer.find(SELECTORS.TITLE).text(title),footerContainer.find(SELECTORS.TEXT).text(text),function(footer){getFooterRequireContactContainer(footer).removeClass("hidden")}(footer),strings}));case"edit-mode":return function(footer){getFooterEditModeContainer(footer).removeClass("hidden")}(footer);case"content":return function(footer){getFooterContentContainer(footer).removeClass("hidden")}(footer);case"unblock":return function(footer){getFooterRequireUnblockContainer(footer).removeClass("hidden")}(footer);case"unable-to-message":return function(footer){getFooterUnableToMessageContainer(footer).removeClass("hidden")}(footer)}return!0},renderScrollToMessage=function(header,body,footer,messageId){var messagesContainer=getMessagesContainer(body),position=getMessageElement(body,messageId).position();if(position){var scrollTop=messagesContainer.scrollTop()+position.top;messagesContainer.scrollTop(scrollTop)}},renderLoadingMembers=function(header,body,footer,isLoadingMembers){isLoadingMembers?(hideHeaderContent(header),showHeaderPlaceholder(header)):(showHeaderContent(header),hideHeaderPlaceholder(header))},renderLoadingFirstMessages=function(header,body,footer,isLoadingFirstMessages){isLoadingFirstMessages?(function(body){getMessagesContainer(body).addClass("hidden")}(body),function(body){getContentPlaceholderContainer(body).removeClass("hidden")}(body)):(function(body){getMessagesContainer(body).removeClass("hidden")}(body),function(body){getContentPlaceholderContainer(body).addClass("hidden")}(body))},renderLoadingMessages=function(header,body,footer,isLoading){isLoading?function(body){getMoreMessagesLoadingIconContainer(body).removeClass("hidden")}(body):function(body){getMoreMessagesLoadingIconContainer(body).addClass("hidden")}(body)},renderShowEmojiPicker=function(header,body,footer,show){var container=function(footer){return footer.find(SELECTORS.EMOJI_PICKER_CONTAINER)}(footer);show?(container.removeClass("hidden"),container.attr("aria-hidden",!1),container.find(SELECTORS.EMOJI_PICKER_SEARCH_INPUT).focus()):(container.addClass("hidden"),container.attr("aria-hidden",!0))},renderShowEmojiAutoComplete=function(header,body,footer,show){var container=function(footer){return footer.find(SELECTORS.EMOJI_AUTO_COMPLETE_CONTAINER)}(footer);show?(container.removeClass("hidden"),container.attr("aria-hidden",!1)):(container.addClass("hidden"),container.attr("aria-hidden",!0))},showConfirmDialogue=function(header,body,footer,buttonSelectors,bodyText,headerText,canCancel,skipHeader,showOk){var dialogue=getConfirmDialogueContainer(body),buttons=buttonSelectors.map((function(selector){return dialogue.find(selector)})),cancelButton=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_CANCEL_BUTTON),okayButton=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_OKAY_BUTTON),text=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_TEXT),dialogueHeader=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_HEADER);(dialogue.find("button").addClass("hidden"),canCancel?cancelButton.removeClass("hidden"):cancelButton.addClass("hidden"),showOk?okayButton.removeClass("hidden"):okayButton.addClass("hidden"),headerText)?((dialogueHeader=$('<h3 class="h6" data-region="dialogue-header"></h3>')).text(headerText),dialogue.find(SELECTORS.CONFIRM_DIALOGUE).prepend(dialogueHeader)):dialogueHeader.length&&dialogueHeader.remove();buttons.forEach((function(button){button.removeClass("hidden")})),text.text(bodyText),showConfirmDialogueContainer(footer),showConfirmDialogueContainer(body),skipHeader||showConfirmDialogueContainer(header),dialogue.find(SELECTORS.CAN_RECEIVE_FOCUS).filter(":visible").first().focus()},hideConfirmDialogue=function(header,body,footer){var dialogue=getConfirmDialogueContainer(body),cancelButton=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_CANCEL_BUTTON),okayButton=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_OKAY_BUTTON),text=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_TEXT),dialogueHeader=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_HEADER);return hideCheckDeleteDialogue(body),hideConfirmDialogueContainer(body),hideConfirmDialogueContainer(footer),hideConfirmDialogueContainer(header),dialogue.find("button").addClass("hidden"),cancelButton.removeClass("hidden"),okayButton.removeClass("hidden"),text.text(""),dialogueHeader.length&&dialogueHeader.remove(),header.find(SELECTORS.CAN_RECEIVE_FOCUS).first().focus(),!0},renderConfirmBlockUser=function(header,body,footer,user){return user?user.canmessageevenifblocked?Str.get_string("cantblockuser","core_message",user.fullname).then((function(string){return showConfirmDialogue(header,body,footer,[],string,"",!1,!1,!0)})):Str.get_string("blockuserconfirm","core_message",user.fullname).then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_BLOCK],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmUnblockUser=function(header,body,footer,user){return user?Str.get_string("unblockuserconfirm","core_message",user.fullname).then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_UNBLOCK],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmAddContact=function(header,body,footer,user){return user?Str.get_string("addcontactconfirm","core_message",user.fullname).then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_ADD_CONTACT],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmRemoveContact=function(header,body,footer,user){return user?Str.get_string("removecontactconfirm","core_message",user.fullname).then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_REMOVE_CONTACT],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmDeleteSelectedMessages=function(header,body,footer,data){var showmessage=null;return data.type==CONVERSATION_TYPES.SELF?showmessage="deleteselectedmessagesconfirmselfconversation":data.canDeleteMessagesForAllUsers?(showCheckDeleteDialogue(body),showmessage="deleteforeveryoneselectedmessagesconfirm"):showmessage="deleteselectedmessagesconfirm",data.show?Str.get_string(showmessage,"core_message").then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_DELETE_SELECTED_MESSAGES],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmDeleteConversation=function(header,body,footer,type){var showmessage=null;return type==CONVERSATION_TYPES.SELF?showmessage="deleteallselfconfirm":type&&(showmessage="deleteallconfirm"),showmessage?Str.get_string(showmessage,"core_message").then((function(string){return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_CONFIRM_DELETE_CONVERSATION],string,"",!0,!1)})):hideConfirmDialogue(header,body,footer)},renderConfirmContactRequest=function(header,body,footer,user){return user?Str.get_string("userwouldliketocontactyou","core_message",user.fullname).then((function(string){var buttonSelectors=[SELECTORS.ACTION_ACCEPT_CONTACT_REQUEST,SELECTORS.ACTION_DECLINE_CONTACT_REQUEST];return showConfirmDialogue(header,body,footer,buttonSelectors,string,"",!1,!0)})):hideConfirmDialogue(header,body,footer)},showCheckDeleteDialogue=function(body){getConfirmDialogueContainer(body).find(SELECTORS.DELETE_MESSAGES_FOR_ALL_USERS_TOGGLE_CONTAINER).removeClass("hidden")},hideCheckDeleteDialogue=function(body){var dialogue=getConfirmDialogueContainer(body),checkboxRegion=dialogue.find(SELECTORS.DELETE_MESSAGES_FOR_ALL_USERS_TOGGLE_CONTAINER);dialogue.find(SELECTORS.DELETE_MESSAGES_FOR_ALL_USERS_TOGGLE).prop("checked",!1),checkboxRegion.addClass("hidden")},renderIsBlocked=function(header,body,footer,isBlocked){isBlocked?(header.find(SELECTORS.ACTION_REQUEST_BLOCK).addClass("hidden"),header.find(SELECTORS.ACTION_REQUEST_UNBLOCK).removeClass("hidden")):(header.find(SELECTORS.ACTION_REQUEST_BLOCK).removeClass("hidden"),header.find(SELECTORS.ACTION_REQUEST_UNBLOCK).addClass("hidden"))},renderIsFavourite=function(header,body,footer,state){var favouriteIcon=header.find(SELECTORS.FAVOURITE_ICON_CONTAINER),addFavourite=header.find(SELECTORS.ACTION_CONFIRM_FAVOURITE),removeFavourite=header.find(SELECTORS.ACTION_CONFIRM_UNFAVOURITE);switch(state){case"hide":favouriteIcon.addClass("hidden"),addFavourite.addClass("hidden"),removeFavourite.addClass("hidden");break;case"show-add":favouriteIcon.addClass("hidden"),addFavourite.removeClass("hidden"),removeFavourite.addClass("hidden");break;case"show-remove":favouriteIcon.removeClass("hidden"),addFavourite.addClass("hidden"),removeFavourite.removeClass("hidden")}},renderIsMuted=function(header,body,footer,state){var muteIcon=header.find(SELECTORS.MUTED_ICON_CONTAINER),setMuted=header.find(SELECTORS.ACTION_CONFIRM_MUTE),unsetMuted=header.find(SELECTORS.ACTION_CONFIRM_UNMUTE);switch(state){case"hide":muteIcon.addClass("hidden"),setMuted.addClass("hidden"),unsetMuted.addClass("hidden");break;case"show-mute":muteIcon.addClass("hidden"),setMuted.removeClass("hidden"),unsetMuted.addClass("hidden");break;case"show-unmute":muteIcon.removeClass("hidden"),setMuted.addClass("hidden"),unsetMuted.removeClass("hidden")}},renderIsContact=function(header,body,footer,state){var addContact=header.find(SELECTORS.ACTION_REQUEST_ADD_CONTACT),removeContact=header.find(SELECTORS.ACTION_REQUEST_REMOVE_CONTACT);switch(state){case"pending-contact":addContact.addClass("hidden"),removeContact.addClass("hidden");break;case"contact":addContact.addClass("hidden"),removeContact.removeClass("hidden");break;case"non-contact":addContact.removeClass("hidden"),removeContact.addClass("hidden")}},renderLoadingConfirmAction=function(header,body,footer,isLoading){var dialogue=getConfirmDialogueContainer(body),buttons=dialogue.find("button"),buttonText=dialogue.find(SELECTORS.CONFIRM_DIALOGUE_BUTTON_TEXT),loadingIcon=dialogue.find(SELECTORS.LOADING_ICON_CONTAINER);isLoading?(buttons.prop("disabled",!0),buttonText.addClass("hidden"),loadingIcon.removeClass("hidden")):(buttons.prop("disabled",!1),buttonText.removeClass("hidden"),loadingIcon.addClass("hidden"))},renderInEditMode=function(header,body,footer,inEditMode){var messages=null;inEditMode?((messages=body.find(SELECTORS.MESSAGE_NOT_SELECTED)).find(SELECTORS.MESSAGE_NOT_SELECTED_ICON).removeClass("hidden"),hideHeaderContent(header),function(header){getHeaderEditMode(header).removeClass("hidden")}(header)):((messages=getMessagesContainer(body)).find(SELECTORS.MESSAGE_NOT_SELECTED_ICON).addClass("hidden"),messages.find(SELECTORS.MESSAGE_SELECTED_ICON).addClass("hidden"),showHeaderContent(header),hideHeaderEditMode(header))},renderSelectedMessages=function(header,body,footer,data){var hasSelectedMessages=data.count>0;data.add.length&&data.add.forEach((function(messageId){var message=getMessageElement(body,messageId);message.find(SELECTORS.MESSAGE_NOT_SELECTED_ICON).addClass("hidden"),message.find(SELECTORS.MESSAGE_SELECTED_ICON).removeClass("hidden"),message.attr("aria-checked",!0)})),data.remove.length&&data.remove.forEach((function(messageId){var message=getMessageElement(body,messageId);hasSelectedMessages&&message.find(SELECTORS.MESSAGE_NOT_SELECTED_ICON).removeClass("hidden"),message.find(SELECTORS.MESSAGE_SELECTED_ICON).addClass("hidden"),message.attr("aria-checked",!1)})),function(header,value){getHeaderEditMode(header).find(SELECTORS.MESSAGES_SELECTED_COUNT).text(value)}(header,data.count)},renderRequireAddContact=function(header,body,footer,data){return data.show&&!data.hasMessages?Str.get_strings([{key:"requirecontacttomessage",component:"core_message",param:data.user.fullname},{key:"isnotinyourcontacts",component:"core_message",param:data.user.fullname}]).then((function(strings){var title=strings[1],text=strings[0];return showConfirmDialogue(header,body,footer,[SELECTORS.ACTION_REQUEST_ADD_CONTACT],text,title,!1,!0)})):hideConfirmDialogue(header,body,footer)},renderSelfConversationMessage=function(header,body,footer,displayMessage){var container=getSelfConversationMessageContainer(body);return displayMessage?container.removeClass("hidden"):container.addClass("hidden"),!0},renderContactRequestSent=function(header,body,footer,userFullName){var container=getContactRequestSentContainer(body);return userFullName?Str.get_string("yourcontactrequestpending","core_message",userFullName).then((function(string){return container.find(SELECTORS.TEXT).text(string),container.removeClass("hidden"),string})):(container.addClass("hidden"),!0)},renderReset=function(header,body,footer){return hideConfirmDialogue(header,body,footer),function(body){getContactRequestSentContainer(body).addClass("hidden")}(body),function(body){getSelfConversationMessageContainer(body).addClass("hidden")}(body),function(header){hideHeaderContent(header),hideHeaderEditMode(header),hideHeaderPlaceholder(header)}(header),showHeaderPlaceholder(header),hideAllFooterElements(footer),showFooterPlaceholder(footer),!0};return{render:function(header,body,footer,patch){var configs=[{reset:renderReset},{conversation:renderConversation,header:renderHeader,footer:renderFooter,confirmBlockUser:renderConfirmBlockUser,confirmUnblockUser:renderConfirmUnblockUser,confirmAddContact:renderConfirmAddContact,confirmRemoveContact:renderConfirmRemoveContact,confirmDeleteSelectedMessages:renderConfirmDeleteSelectedMessages,confirmDeleteConversation:renderConfirmDeleteConversation,confirmContactRequest:renderConfirmContactRequest,requireAddContact:renderRequireAddContact,selfConversationMessage:renderSelfConversationMessage,contactRequestSent:renderContactRequestSent},{loadingMembers:renderLoadingMembers,loadingFirstMessages:renderLoadingFirstMessages,loadingMessages:renderLoadingMessages,isBlocked:renderIsBlocked,isContact:renderIsContact,isFavourite:renderIsFavourite,isMuted:renderIsMuted,loadingConfirmAction:renderLoadingConfirmAction,inEditMode:renderInEditMode,showEmojiPicker:renderShowEmojiPicker,showEmojiAutoComplete:renderShowEmojiAutoComplete},{scrollToMessage:renderScrollToMessage,selectedMessages:renderSelectedMessages}],processConfig=function(config){var results=[];for(var key in patch)if(config.hasOwnProperty(key)){var renderFunc=config[key],patchValue=patch[key];results.push(renderFunc(header,body,footer,patchValue))}return results},renderingPromises=processConfig(configs[0]);return renderingPromises=renderingPromises.concat(processConfig(configs[1])),$.when.apply($,renderingPromises).then((function(){for(var i=2;i<configs.length;i++)processConfig(configs[i])})).catch(Notification.exception)}}}));

//# sourceMappingURL=message_drawer_view_conversation_renderer.min.js.map